/**
 * @file Drv_LCD.c
 * @author 吳星萍 (iris@e-besthealth.com)
 * @brief  lcd display 調用接口
 * @version 0.1
 * @date 2020-07-12
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.03
 * MCU/CFG  Ver. : BH67F5362/1.1
 */

#include "Project_Global.h"
#include "BH67F5362.h"
#include "Drv_LCD.h"
#include "Drv_GPIO.h"

#define LCD_RAM_SIZE 0x2d

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 變量定義 @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

//----------------------------------SEG -----------------------------------//
#define      a  	((0x0001)<<11)
#define      b		((0x0001)<<10)
#define      c   	((0x0001)<<9)
#define      d   	((0x0001)<<0)
#define      e   	((0x0001)<<1)
#define      f   	((0x0001)<<3)
#define      g   	((0x0001)<<2)
#define      h   	((0x0001)<<8)


const unsigned int Display_Table[]=
{
	a + b + c + d + e + f,						// Displays "0"  	// 0
	b + c,										// Displays "1"  	// 1
	a + b + d + e + g,							// Displays "2"  	// 2
	a + b + c + d + g,							// Displays "3"  	// 3
	b + c + f + g,								// Displays "4"  	// 4
	a + c + d + f +g,							// Displays "5"  	// 5
	a + c + d + e + f + g,						// Displays "6"  	// 6
	a + b + c,									// Displays "7"  	// 7
	a + b + c + d + e + f + g,					// Displays "8"  	// 8
	a + b + c + d + f + g,						// Displays "9"  	// 9
	a + b + c + e + f + g,						// Displays "A"  	// 10
	c + d + e + f + g,							// Displays "B"  	// 11
	a + d + e + f,								// Displays "C"  	// 12
	b + c + d + e + g,							// Displays "D"  	// 13
	a + d + e + f + g,							// Displays "E"  	// 14
	a + e + f + g,								// Displays "F"  	// 15
	a + c + d + e + f,							// Displays "G"  	// 16
	b + c + e + f + g,							// Displays "H"  	// 17
	e + f,										// Displays "I"  	// 18
	b + c + d + e,								// Displays "J"  	// 19
	b + d + e + f + g,							// Displays "K"  	// 20
	d + e + f,									// Displays "L"  	// 21
	a + c + e + g,								// Displays "M"  	// 22
	a + b + c + e + f,							// Displays "N"  	// 23
	c + e + g,									// Displays "n"  	// 24
	c + d + e + g,								// Displays "o"  	// 25
	a + b + c + d + e + f,						// Displays "O"  	// 26
	a + b + e + f + g,							// Displays "P"  	// 27
	a + b + c + f + g,							// Displays "Q"  	// 28
	e + g,										// Displays "r"  	// 29
	a + c + d + f +g,							// Displays "S"  	// 30
	d + e + f + g,								// Displays "t"  	// 31
	a + e + f , 								// Displays "T"		// 32
	b + c + d + e + f,							// Displays "U" 	// 33
	c + d + e,									// Displays "v"   	// 34
	b + d + f + g,								// Displays "W"  	// 35
	b + c + d + f + g,							// Displays "Y"   	// 36
	a + b + d + e + g,							// Displays "Z"  	// 37
	g,											// Displays "-"  	// 38
	b,											// Displays "'"   	// 39
	0,											// Displays " "  	// 40
	a + b + c + d + e + f + g + h,				// Displays "8."  	// 41
};

/**
 * @brief LCD ram all on
 *
 */
void Drv_LCD_Display_All()
{
	_mp1h = 4;
	_mp1l = 0x00;
	for(_tblp = 0x00;_tblp <= LCD_RAM_SIZE;_tblp++)
	{
		_iar1 = 0x0F;
		_mp1l++;
	}
}

/**
 * @brief LCD Ram clear
 *
 */
void Drv_LCD_Display_Clear()
{
	_mp1h = 4;
	_mp1l = 0x00;
	for(_tblp = 0x00;_tblp <= LCD_RAM_SIZE;_tblp++)
	{
		_iar1 = 0x00;
		_mp1l++;
	}
}

/**
 * @brief LCD 上電初始化
 *
 */
void Drv_LCD_Init()
{
	SET_PG0_COM0();
	SET_PG1_COM1();
	SET_PG2_COM2();
	SET_PG3_COM3();
	SET_PG4_SEG0();
	SET_PG5_SEG1();
	SET_PG6_SEG2();
	SET_PG7_SEG3();
	SET_PE0_SEG7();
	SET_PF2_SEG11();
	SET_PB2_SEG14();
	SET_PA7_SEG15();
	SET_PA6_SEG16();
	SET_PA5_SEG17();
	SET_PA4_SEG18();
	SET_PA3_SEG19();
	SET_PA1_SEG20();
	SET_PB3_SEG21();
	SET_PB4_SEG22();
	SET_PA2_SEG23();
	SET_PA0_SEG24();
	SET_PB1_SEG25();
	SET_PB0_SEG26();
	SET_PD6_SEG27();
	SET_PB7_SEG28();
	SET_PB6_SEG29();
	SET_PB5_SEG30();
	SET_PF6_SEG31();	
	SET_PD1_SEG34();
	SET_PD0_SEG35();
	SET_PC7_SEG36();
	SET_PC6_SEG37();
	SET_PC5_SEG38();
	SET_PC4_SEG39();
	SET_PC3_SEG40();
	SET_PC2_SEG41();
	SET_PC0_SEG42();
	SET_PE7_SEG43();
	SET_PE6_SEG44();
	SET_PE5_SEG45();
	SET_PE5_C2();
	SET_PE6_C1();
	SET_PE7_V2();

	SET_LCD_C_TYPE_POWER_VC();
	SET_LCD_TYPE_C();
	SET_LCD_TYPE_A();
	SET_LCD_4DUTY();
	SET_LCD_3BIAS();
	SET_LCD_POWER(ON);
}

/********************************************************************
Function: 更新顯示到LCD屏
INPUT	:
OUTPUT	: gu8v_LED_Buffer[5] High → gu8v_LED_Buffer[0] Low
NOTE	:
********************************************************************/
void Drv_LCDDisplayUpdate()
{
	Display_LCD_Map[0].u16 |= Display_Table[DisplayBCDBuf[0]];			//use seg0~1,so is Display_LCD_Map[0]
	Display_LCD_Map[1].u16 |= Display_Table[DisplayBCDBuf[1]];      
	Display_LCD_Map[3].u16 |= (Display_Table[DisplayBCDBuf[2]]&0x0ff)<<8;       
	Display_LCD_Map[5].u16 |= (Display_Table[DisplayBCDBuf[2]]&0xff00);
	Display_LCD_Map[7].u16 |= Display_Table[DisplayBCDBuf[3]];
	Display_LCD_Map[8].u16 |= Display_Table[DisplayBCDBuf[4]];
	Display_LCD_Map[9].u16 |= Display_Table[DisplayBCDBuf[5]];
}